//
// Torus-Knot.js
//  inspired by Grapher
//
//  v.061020
//  required version : Cheetah3D v3.4
//
//  (c) 2006 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

function buildUI(obj) {
    
    obj.setParameter("name","Torus-Knot");
    
    obj.addParameterInt("section",50,10,3600,true,true);
    
    obj.addParameterSeparator("variables");
    obj.addParameterFloat("a",3,-1000,1000,true,true);
    obj.addParameterFloat("p",3,-1000,1000,true,true);
    obj.addParameterFloat("q",7,-1000,1000,true,true);    
    
}

function buildObject(obj) {
    var i,j,k;
    var spline = obj.core();
    var section = obj.getParameter("section");
    var a = obj.getParameter("a");
    var p = obj.getParameter("p");
    var q = obj.getParameter("q");
    
    for (i = 0;i < section;i++) {
        var ang_i = Math.PI*2*p/section*i;
        var pos = new Vec3D(a+Math.cos(q/p*ang_i),
                0,
                Math.sin(q/p*ang_i));
        var mat = new Mat4D(ROTATE,0,0,ang_i*180/Math.PI);
        pos = mat.multiply(pos);
        if (i == 0) spline.move(pos);
        else        spline.line(pos);
    }
    
    spline.close();
}

